function [scatter] = ResourseAnalysis(Hs,Te,DirP,HsMAX,TeMAX,Data,dHs,dTe,OCC,POW,TS,ROSE,PLOT)
% Hs, Te, DirP: Vectors for significant wave height, mean period, and mean wave direction
% HsMAX e TeMAX: max of da Hs e Te
% Data: timestamps in datetime format
% dHs: delta Hs for scatter discretization--> usually 0.25
% dTe: delta Te for scatter discretization--> usually 0.5
% OCC: flag, 1 for occurrencies scatter
% POW: flag, 1 for power scatter
% TS:  flag, 1 for timestamp-visualization
% ROSE: flag, 1 wave rose
% PLOTS: Occ-Te; Energy-Te, Occ-Hs, Energy-Hs, (Occ_cumulative e Ene_cumulative)-Te, (Occ_cumulative e Ene_cumulative)-Hs 
%
set(0,'DefaultAxesFontSize',20,'DefaultLineLineWidth', 1.5, 'DefaultAxesLineWidth',0.2);

%% check on the input variables

k = 0;
index = nan([length(Hs) 1]);
for ir=1:length(Hs)
    if Te(ir)>20 || Te(ir)<0  || Hs(ir)<0.015  || Hs(ir)>10 || DirP(ir)>360 || DirP(ir)<0 
        k = k+1;
        index(k) = ir;
    end
end
index(isnan(index)) = [];
Hs(index)   = [];
Te(index)   = [];
DirP(index) = [];
Data(index) = [];

%% Generating scatter matrices

time  = 1:length(Hs); % time stamps
Temax = ceil(max(Te));
Hsmax = ceil(max(Hs));

% Creating Bin
nBinHs = (Hsmax/dHs)+1;
nBinTe = (Temax/dTe)+1;
Hs_bin = linspace(0,Hsmax,nBinHs);% min(Hs), max(Hs), bin number
Te_bin = linspace(0,Temax,nBinTe);% min(Tp), max(Tp), bin number
Ntot   = length(time);

[scatter] = scatter_output(Hs,Te,DirP,Hs_bin,Te_bin,Ntot);

scatter.Hs_bin = Hs_bin;
scatter.Te_bin = Te_bin;

Hs_mat = repmat(Hs_bin',1,nBinTe);
Te_mat = repmat(Te_bin,nBinHs,1);
Occurr = scatter.occ;
scatter.Te_mat = Te_mat;
scatter.Hs_mat = Hs_mat;


if OCC == 1 % Scatter delle occorrenze -------------------------------------
figure ()
surface(Te_mat,Hs_mat,Occurr)
ylim([0 Hsmax])
xlim([0 Temax])
xlabel('$T_e$ [s]')
ylabel('$H_s$ [m]')
Numb_Occurr = sum(sum(Occurr));
Numb_Occurr_better = round(Numb_Occurr,3,'significant');
title(['Sum of occurrences = ',num2str(sum(sum(Occurr)))])
colorbar
end

if POW == 1 % Scatter dell'energia -----------------------------------------
Energy = scatter.energy;
figure ()
surface(Te_mat,Hs_mat,Energy)
ylim([0 Hsmax])
xlim([0 Temax])
xlabel('$T_e$ [s]')
ylabel('$H_s$ [m]')
Numb_Energy = sum(sum(Energy));
% Numb_Energy_round = round(Numb_Energy,4,'significant');
title({['Energy density = ',num2str(Numb_Energy*1e-3,'%1.2f') '[MWh/m/year]'];
['Mean power = ',num2str(Numb_Energy/24/365,'%1.2f'),'[kW/m]']})
colorbar  
end

if TS == 1 % Serie temporali (hs,Te,DirP) -----------------------------------
% serie temporale di Hs
    figure()
    plot(Data,Hs,'.k');hold on;
    grid on;
    grid minor;
    xlabel('Date');
    ylabel('$H_s$ [m]')
    xlim([Data(1) Data(end)])
    ylim([0 HsMAX])
% serie temporale di Te   
    figure()
    plot(Data,Te,'.k'); hold on;
    grid on;
    grid minor;
    xlabel('Date');
    ylabel('$T_e$ [s]');
    xlim([Data(1) Data(end)])
    ylim([0 TeMAX])
% serie temporale di DirP
    figure()
    plot(Data,DirP,'.k'); hold on;
    grid on;
    grid minor;
    xlabel('Date');
    ylabel('Mean Direction [$^\circ$]')
    xlim([Data(1) Data(end)])
end

if ROSE == 1 % Rosa delle onde ----------------------------------------------
    figure()
    wind_roseg(DirP,Hs,'quad',1,'dtype','meteo','umisura','m','parametric','h_s','di',[0:1:HsMAX]);
    title('Rosa delle onde');
end

if PLOT==1 % PLOT sulla risorsa -------------------------------------------
% plot Occ-Te
figure ()
Occ_Te=sum(Occurr)*100;
plot(Te_bin,Occ_Te); hold on;
grid on;
grid minor;
xlabel('$T_e$ [s]')
ylabel('Occurrences (\%)')
xlim([0 TeMAX])
% plot Energy-Te
figure ()
Ene_Te=sum(Energy);
plot(Te_bin,Ene_Te, 'Color', [1 0.3 0.2]); hold on;
grid on;
grid minor;
xlabel('$T_e$ [s]')
ylabel('Energy [kWh/m/year]')
xlim([0 TeMAX])
% plot Occ-Hs
figure ()
Occ_Hs=sum(Occurr')*100;
plot(Hs_bin,Occ_Hs); hold on;
grid on;
grid minor;
xlabel('$H_s$ [m]')
ylabel('Occurrences (\%)')
xlim([0 HsMAX])
% plot Energy-Hs
figure ()
Ene_Hs=sum(Energy');
plot(Hs_bin,Ene_Hs, 'Color', [1 0.3 0.2]); hold on;
grid on;
grid minor;
xlabel('$H_s$ [m]')
ylabel('Energy [kWh/m/year]')
xlim([0 HsMAX])
% plot (Occ_cumulative e Ene_cumulative)- Te
Occ_cumulative_Te=Occ_Te;
Ene_cumulative_Te=Ene_Te;
for ii=2:length(Te_bin)
Ene_cumulative_Te(ii)= Ene_cumulative_Te(ii)+Ene_cumulative_Te(ii-1);
Occ_cumulative_Te(ii)= Occ_cumulative_Te(ii)+Occ_cumulative_Te(ii-1);
end
numb_Te=100/Ene_cumulative_Te(end);
Ene_cumulative_Te=Ene_cumulative_Te.*numb_Te;
figure ()
yyaxis left
plot(Te_bin,Occ_cumulative_Te); hold on;
grid on;
grid minor;
ylabel('Occurrences (\%)')
ylim([0 100])
xlabel('$T_e$ [s]')
yyaxis right
plot(Te_bin,Ene_cumulative_Te); hold on;
grid on;
grid minor;
ylabel('Energy (\%)')
ylim([0 100])
xlim([0 TeMAX])
% plot (Occ_cumulative e Ene_cumulative)- Hs
Occ_cumulative_Hs=Occ_Hs;
Ene_cumulative_Hs=Ene_Hs;
for ii=2:length(Hs_bin)
Ene_cumulative_Hs(ii)= Ene_cumulative_Hs(ii)+Ene_cumulative_Hs(ii-1);
Occ_cumulative_Hs(ii)= Occ_cumulative_Hs(ii)+Occ_cumulative_Hs(ii-1);
end
numb_Hs=100/Ene_cumulative_Hs(end);
Ene_cumulative_Hs=Ene_cumulative_Hs.*numb_Hs;
figure ()
yyaxis left
plot(Hs_bin,Occ_cumulative_Hs); hold on;
grid on;
grid minor;
ylabel('Occurrences (\%)')
ylim([0 100])
xlabel('$H_s$ [m]')
yyaxis right
plot(Hs_bin,Ene_cumulative_Hs); hold on;
grid on;
grid minor;
ylabel('Energy (\%)')
ylim([0 100])
xlim([0 HsMAX])
end
end